# import cv2
# import numpy as np
# import tensorflow as tf
# import yaml
# import os

# class YOLOv8TFLiteDetector:
#     def __init__(self, model_path: str, class_names_path: str, conf_threshold: float = 0.25, iou_threshold: float = 0.45):
#         self.model_path = model_path
#         self.class_names_path = class_names_path
#         self.conf_threshold = conf_threshold
#         self.iou_threshold = iou_threshold

#         # التحقق من وجود الملفات
#         if not os.path.exists(self.model_path):
#             raise FileNotFoundError(f"Model file not found at {self.model_path}")
#         if not os.path.exists(self.class_names_path):
#             raise FileNotFoundError(f"Class names file not found at {self.class_names_path}")

#         self._load_model()
#         self._load_class_names()

#     def _load_model(self):
#         try:
#             self.interpreter = tf.lite.Interpreter(model_path=self.model_path)
#             print(f"✅ Model loaded successfully from {self.model_path}")
#         except Exception as e:
#             raise RuntimeError(f"Failed to load model: {e}")

#         self.interpreter.allocate_tensors()
#         self.input_details = self.interpreter.get_input_details()
#         self.output_details = self.interpreter.get_output_details()

#         self.input_shape = self.input_details[0]['shape']
#         self.input_dtype = self.input_details[0]['dtype']
        
#         print(f"Model input details: {self.input_details}")
#         print(f"Model output details: {self.output_details}")

#     def _load_class_names(self):
#         with open(self.class_names_path, 'r', encoding='utf-8') as file:
#             data = yaml.safe_load(file)
#         self.class_names = data['names']
#         print(f"Loaded {len(self.class_names)} class names")

#     # def _preprocess_image(self, image: np.ndarray) -> np.ndarray:
#     #     # التحقق من أن الصورة صالحة
#     #     if image is None or image.size == 0:
#     #         raise ValueError("Invalid image: Empty or None")

#     #     # طباعة شكل الصورة الأصلية للمساعدة في التشخيص
#     #     print(f"Original image shape: {image.shape}")

#     #     # الحصول على الأبعاد المتوقعة من النموذج
#     #     _, target_height, target_width, _ = self.input_shape  # NHWC format (1, 640, 640, 3)
        
#     #     # تغيير حجم الصورة مع الحفاظ على النسبة (مع Padding إذا لزم الأمر)
#     #     img_resized = cv2.resize(image, (target_width, target_height))
#     #     img_rgb = cv2.cvtColor(img_resized, cv2.COLOR_BGR2RGB)
        
#     #     # تطبيع القيم
#     #     input_tensor = img_rgb.astype(np.float32) / 255.0
        
#     #     # إضافة بُعد الدُفعة (batch dimension)
#     #     input_tensor = np.expand_dims(input_tensor, axis=0)
        
#     #     # التحويل إلى uint8 إذا كان النموذج يتوقع ذلك
#     #     if self.input_dtype == np.uint8:
#     #         input_tensor = (input_tensor * 255).astype(np.uint8)
        
#     #     print(f"Preprocessed tensor shape: {input_tensor.shape}")
#     #     print(f"Input tensor dtype: {input_tensor.dtype}")
#     #     return input_tensor


#     def _preprocess_image(self, image: np.ndarray) -> np.ndarray:
#     # التحقق من أن الصورة صالحة
#       if image is None or image.size == 0:
#           raise ValueError("Invalid image: Empty or None")

#     # طباعة شكل الصورة الأصلية للمساعدة في التشخيص
#       print(f"Original image shape: {image.shape}")

#     # الحصول على الأبعاد المتوقعة من النموذج (تنسيق NCHW)
#       _, channels, height, width = self.input_shape
    
#     # تغيير حجم الصورة مع الحفاظ على النسبة (مع حشو إذا لزم الأمر)
#       img_resized = cv2.resize(image, (width, height))
    
#     # تحويل BGR إلى RGB إذا كانت الصورة ملونة
#       if len(img_resized.shape) == 3:
#           img_rgb = cv2.cvtColor(img_resized, cv2.COLOR_BGR2RGB)
#       else:
#           img_rgb = cv2.cvtColor(img_resized, cv2.COLOR_GRAY2RGB)
    
#     # تغيير الأبعاد إلى CHW وتطبيع القيم
#       input_tensor = np.transpose(img_rgb, (2, 0, 1)).astype(np.float32) / 255.0
    
#     # إضافة بُعد الدُفعة (NCHW)
#       input_tensor = np.expand_dims(input_tensor, axis=0)
    
#     # التحقق من تطابق الأبعاد
#       if input_tensor.shape != tuple(self.input_shape):
#           print(f"⚠️ Warning: Input tensor shape {input_tensor.shape} doesn't match model input shape {self.input_shape}")
#         # إعادة تشكيل Tensor إذا لزم الأمر
#           input_tensor = np.resize(input_tensor, tuple(self.input_shape))
    
#       print(f"✅ Preprocessed tensor shape: {input_tensor.shape}")
#       print(f"Input tensor dtype: {input_tensor.dtype}")
#       return input_tensor


   

#     def _sigmoid(self, x):
#         return 1 / (1 + np.exp(-x))

#     def _decode_yolov8_output(self, raw_output: np.ndarray, orig_w: int, orig_h: int) -> list:
#         boxes = []
#         scores = []
#         class_ids = []

#         # تحويل الإخراج إذا كان بالشكل الخاطئ
#         if raw_output.shape[0] == (4 + len(self.class_names)):
#             raw_output = raw_output.T

#         for pred in raw_output:
#             x_center, y_center, width, height = pred[0], pred[1], pred[2], pred[3]
#             objectness = self._sigmoid(pred[4])
#             class_probs = self._sigmoid(pred[5:])

#             class_id = np.argmax(class_probs)
#             class_score = class_probs[class_id]
#             confidence = objectness * class_score

#             if confidence < self.conf_threshold:
#                 continue

#             # تحويل الإحداثيات إلى الصورة الأصلية
#             x1 = int((x_center - width / 2) * orig_w)
#             y1 = int((y_center - height / 2) * orig_h)
#             x2 = int((x_center + width / 2) * orig_w)
#             y2 = int((y_center + height / 2) * orig_h)

#             boxes.append([x1, y1, x2, y2])
#             scores.append(confidence)
#             class_ids.append(class_id)

#         # تطبيق Non-Maximum Suppression
#         nms_boxes = [[x1, y1, x2 - x1, y2 - y1] for x1, y1, x2, y2 in boxes]
#         indices = cv2.dnn.NMSBoxes(nms_boxes, scores, self.conf_threshold, self.iou_threshold)

#         results = []
#         if len(indices) > 0:
#             for i in indices.flatten():
#                 results.append({
#                     "bbox": boxes[i],
#                     "score": float(scores[i]),
#                     "class_id": int(class_ids[i]),
#                     "class_name": self.class_names[class_ids[i]] if class_ids[i] < len(self.class_names) else f"class_{class_ids[i]}"
#                 })

#         return results

#     def detect_image(self, image_np: np.ndarray) -> list:
#         try:
#             orig_h, orig_w = image_np.shape[:2]
#             input_tensor = self._preprocess_image(image_np)
            
#             # التحقق من تطابق الأبعاد قبل تعيين الـ tensor
#             if input_tensor.shape != tuple(self.input_shape):
#                 raise ValueError(f"Input tensor shape {input_tensor.shape} doesn't match model input shape {self.input_shape}")
            
#             self.interpreter.set_tensor(self.input_details[0]['index'], input_tensor)
#             self.interpreter.invoke()
            
#             raw_output = self.interpreter.get_tensor(self.output_details[0]['index'])[0]
#             detections = self._decode_yolov8_output(raw_output, orig_w, orig_h)
            
#             print(f"Detected {len(detections)} objects")
#             return detections
            
#         except Exception as e:
#             print(f"Error during detection: {str(e)}")
#             raise











# import tensorflow as tf
# import numpy as np
# import cv2
# import logging

# logging.basicConfig(level=logging.INFO)
# logger = logging.getLogger("object_detection.yolov8_tflite_detector")

# class YOLOv8TFLiteDetector:
#     def __init__(self, model_path, class_names_path):
#         self.class_names_path = class_names_path
#         self.class_names = self.load_class_names(class_names_path)

#         self.interpreter = tf.lite.Interpreter(model_path=model_path)
#         self.interpreter.allocate_tensors()
#         self.input_details = self.interpreter.get_input_details()
#         self.output_details = self.interpreter.get_output_details()

#     def load_class_names(self, path):
#         with open(path, "r") as f:
#             return [line.strip() for line in f.readlines()]

#     def detect_objects(self, frame):
#         logger.info("Starting object detection...")
#         height, width, _ = frame.shape

#         input_data = cv2.resize(frame, (640, 640))
#         input_data = cv2.cvtColor(input_data, cv2.COLOR_BGR2RGB)
#         input_data = input_data.astype(np.float32)
#         input_data = np.expand_dims(input_data, axis=0)
#         print("Input shape before set_tensor:", input_data.shape)

#         self.interpreter.set_tensor(self.input_details[0]['index'], input_data)
#         self.interpreter.invoke()

#         output_data = self.interpreter.get_tensor(self.output_details[0]['index'])

#         results = []
#         for det in output_data[0]:
#             if det[4] > 0.5:
#                 x_center, y_center, w, h = det[0:4]
#                 class_id = int(det[5])
#                 class_name = self.class_names[class_id] if class_id < len(self.class_names) else "unknown"

#                 x_min = int((x_center - w / 2) * width)
#                 y_min = int((y_center - h / 2) * height)
#                 x_max = int((x_center + w / 2) * width)
#                 y_max = int((y_center + h / 2) * height)

#                 results.append({
#                     "bbox": [x_min, y_min, x_max, y_max],
#                     "score": float(det[4]),
#                     "class_id": class_id,
#                     "class_name": class_name
#                 })

#         logger.info(f"Detection completed - Found {len(results)} objects")
#         return results











# import cv2
# import numpy as np
# import tensorflow as tf
# import yaml
# import os
# from typing import List, Dict, Any

# class YOLOv8TFLiteDetector:
#     def __init__(self, model_path: str, class_names_path: str,
#                  conf_threshold: float = 0.5,
#                  iou_threshold: float = 0.45):
#         self.model_path = model_path
#         self.class_names_path = class_names_path
#         self.conf_threshold = conf_threshold
#         self.iou_threshold = iou_threshold

#         if not os.path.exists(model_path):
#             raise FileNotFoundError(f"Model file not found: {model_path}")
#         if not os.path.exists(class_names_path):
#             raise FileNotFoundError(f"Class names file not found: {class_names_path}")

#         self._load_model()
#         self._load_class_names()

#     def _load_model(self):
#         """إصدار متوافق مع جميع إصدارات TensorFlow"""
#         try:
#             # المحاولة مع الخيارات إذا كانت متاحة
#             if hasattr(tf.lite, 'InterpreterOptions'):
#                 options = tf.lite.InterpreterOptions()
#                 if hasattr(options, 'num_threads'):
#                     options.num_threads = 4
#                 self.interpreter = tf.lite.Interpreter(
#                     model_path=self.model_path,
#                     options=options
#                 )
#             else:
#                 self.interpreter = tf.lite.Interpreter(model_path=self.model_path)
            
#             self.interpreter.allocate_tensors()
#             self.input_details = self.interpreter.get_input_details()
#             self.output_details = self.interpreter.get_output_details()
#             self.input_shape = tuple(self.input_details[0]['shape'])
#             print(f"Model loaded. Input shape: {self.input_shape}")
            
#         except Exception as e:
#             raise RuntimeError(f"Model loading failed: {str(e)}")

#     def _load_class_names(self):
#         with open(self.class_names_path, 'r', encoding='utf-8') as f:
#             data = yaml.safe_load(f)
#         self.class_names = data['names']
#         print(f"Loaded {len(self.class_names)} classes")

#     def detect_image(self, image: np.ndarray) -> List[Dict[str, Any]]:
#         """إصدار مبسط وآمن للكشف"""
#         try:
#             # المعالجة المسبقة
#             img_resized = cv2.resize(image, (self.input_shape[2], self.input_shape[1]))
#             img_rgb = cv2.cvtColor(img_resized, cv2.COLOR_BGR2RGB)
#             input_tensor = np.expand_dims(img_rgb.astype(np.float32) / 255.0, axis=0)
            
#             # ضبط وتنفيذ النموذج
#             self.interpreter.set_tensor(self.input_details[0]['index'], input_tensor)
#             self.interpreter.invoke()
            
#             # الحصول على المخرجات
#             output_data = np.array(
#                 self.interpreter.get_tensor(self.output_details[0]['index']),
#                 dtype=np.float32
#             )
            
#             return self._decode_output(output_data[0], image.shape[1], image.shape[0])
            
#         except Exception as e:
#             print(f"Detection error: {str(e)}")
#             return []

#     def _decode_output(self, raw_output: np.ndarray, img_w: int, img_h: int) -> List[Dict[str, Any]]:
#         """فك تشفير المخرجات"""
#         try:
#             if raw_output.shape[0] == (4 + len(self.class_names)):
#                 raw_output = raw_output.T

#             boxes = []
#             scores = []
#             class_ids = []
            
#             for pred in raw_output:
#                 x, y, w, h = pred[:4]
#                 conf = 1 / (1 + np.exp(-pred[4])) * 1 / (1 + np.exp(-pred[5:])).max()
                
#                 if conf < self.conf_threshold:
#                     continue
                    
#                 x1 = int((x - w/2) * img_w)
#                 y1 = int((y - h/2) * img_h)
#                 x2 = int((x + w/2) * img_w)
#                 y2 = int((y + h/2) * img_h)
                
#                 boxes.append([x1, y1, x2, y2])
#                 scores.append(float(conf))
#                 class_ids.append(int(np.argmax(pred[5:])))

#             indices = cv2.dnn.NMSBoxes(
#                 [[x1, y1, x2-x1, y2-y1] for x1,y1,x2,y2 in boxes],
#                 scores,
#                 self.conf_threshold,
#                 self.iou_threshold
#             ) if boxes else []
            
#             return [
#                 {
#                     "bbox": boxes[i],
#                     "score": scores[i],
#                     "class_id": class_ids[i],
#                     "class_name": self.class_names[class_ids[i]]
#                 }
#                 for i in indices.flatten()
#             ] if indices is not None else []
            
#         except Exception as e:
#             print(f"Decoding error: {str(e)}")
#             return []


        





# import cv2
# import numpy as np
# import tensorflow as tf
# import yaml
# import threading

# class YOLOv8TFLiteDetector:
#     def __init__(self, model_path: str, class_names_path: str, conf_threshold: float = 0.25, iou_threshold: float = 0.45):
#         self.model_path = model_path
#         self.class_names_path = class_names_path
#         self.conf_threshold = conf_threshold
#         self.iou_threshold = iou_threshold

#         self.lock = threading.Lock()  # قفل لحماية interpreter من الوصول المتزامن

#         self._load_model()
#         self._load_class_names()

#     def _load_model(self):
#         self.interpreter = tf.lite.Interpreter(model_path=self.model_path)
#         self.interpreter.allocate_tensors()

#         self.input_details = self.interpreter.get_input_details()
#         self.output_details = self.interpreter.get_output_details()

#         self.input_shape = self.input_details[0]["shape"]
#         self.input_dtype = self.input_details[0]["dtype"]
        
#         print(f"Model input shape: {self.input_shape}")
#         print(f"Model input dtype: {self.input_dtype}")

#     def _load_class_names(self):
#         with open(self.class_names_path, "r", encoding='utf-8') as file:
#             data = yaml.safe_load(file)
#         self.class_names = data["names"]

#     def _preprocess_image(self, image: np.ndarray) -> np.ndarray:
#         _, c, h, w = self.input_shape  # (1, 3, 640, 640)

#         img_resized = cv2.resize(image, (w, h))
#         img_rgb = cv2.cvtColor(img_resized, cv2.COLOR_BGR2RGB)
#         input_tensor = img_rgb.astype(np.float32) / 255.0
#         input_tensor = np.transpose(input_tensor, (2, 0, 1))  # تحويل HWC → CHW
#         input_tensor = np.expand_dims(input_tensor, axis=0)  # أبعاد الدُفعة

#         if self.input_dtype == np.uint8:
#             input_tensor = (input_tensor * 255).astype(np.uint8)

#         return input_tensor

#     def _sigmoid(self, x):
#         return 1 / (1 + np.exp(-np.clip(x, -250, 250)))

#     def _decode_yolov8_output(self, raw_output: np.ndarray, orig_w: int, orig_h: int) -> list:
#         boxes = []
#         scores = []
#         class_ids = []

#         if raw_output.shape[0] == (4 + len(self.class_names)):
#             raw_output = raw_output.T

#         for pred in raw_output:
#             if len(pred) < 5 + len(self.class_names):
#                 continue
                
#             x_center, y_center, width, height = pred[0], pred[1], pred[2], pred[3]
#             objectness = self._sigmoid(pred[4])
#             class_probs = self._sigmoid(pred[5:5+len(self.class_names)])

#             class_id = np.argmax(class_probs)
#             class_score = class_probs[class_id]
#             confidence = objectness * class_score

#             if confidence < self.conf_threshold:
#                 continue

#             x1 = int((x_center - width / 2) * orig_w)
#             y1 = int((y_center - height / 2) * orig_h)
#             x2 = int((x_center + width / 2) * orig_w)
#             y2 = int((y_center + height / 2) * orig_h)

#             x1 = max(0, min(x1, orig_w))
#             y1 = max(0, min(y1, orig_h))
#             x2 = max(0, min(x2, orig_w))
#             y2 = max(0, min(y2, orig_h))

#             boxes.append([x1, y1, x2, y2])
#             scores.append(confidence)
#             class_ids.append(class_id)

#         if len(boxes) > 0:
#             nms_boxes = [[x1, y1, x2 - x1, y2 - y1] for x1, y1, x2, y2 in boxes]
#             indices = cv2.dnn.NMSBoxes(nms_boxes, scores, self.conf_threshold, self.iou_threshold)

#             results = []
#             if len(indices) > 0:
#                 for i in indices.flatten():
#                     results.append({
#                         "bbox": boxes[i],
#                         "score": float(scores[i]),
#                         "class_id": int(class_ids[i]),
#                         "class_name": self.class_names[class_ids[i]] if class_ids[i] < len(self.class_names) else f"class_{class_ids[i]}"
#                     })
#             return results
#         else:
#             return []

#     def detect_image(self, image_np: np.ndarray) -> list:
#         try:
#             orig_h, orig_w = image_np.shape[:2]
#             input_tensor = self._preprocess_image(image_np)
#             input_tensor_copy = np.copy(input_tensor)  # نسخ لتجنب المرجع

#             with self.lock:
#                 self.interpreter.set_tensor(self.input_details[0]['index'], input_tensor_copy)
#                 self.interpreter.invoke()
#                 raw_output = self.interpreter.get_tensor(self.output_details[0]['index']).copy()[0]

#             detections = self._decode_yolov8_output(raw_output, orig_w, orig_h)
#             print(f"Detected {len(detections)} objects")
#             return detections

#         except Exception as e:
#             print(f"Error during detection: {str(e)}")
#             return []


#افضل كود لتجريب اللايف ستريم
# import cv2
# import requests
# import threading
# import time

# SERVER_URL = "http://127.0.0.1:8000/detect_objects_stream"  # غيري حسب مكان السيرفر

# # دقة الكاميرا
# CAPTURE_WIDTH = 640
# CAPTURE_HEIGHT = 480

# cap = cv2.VideoCapture(1)
# cap.set(cv2.CAP_PROP_FRAME_WIDTH, CAPTURE_WIDTH)
# cap.set(cv2.CAP_PROP_FRAME_HEIGHT, CAPTURE_HEIGHT)
# # cap.set(cv2.CAP_PROP_FPS, 20)  # جربي بدونها أو مع اعتماد الكاميرا

# if not cap.isOpened():
#     print("❌ لم يتم العثور على الكاميرا")
#     exit()

# # متغير لمشاركة الفريم بين الخيوط
# frame_to_send = None
# lock = threading.Lock()
# running = True

# def send_frame():
#     global frame_to_send, running
#     while running:
#         if frame_to_send is not None:
#             with lock:
#                 # ضغط الصورة قبل الإرسال (جودة 80%)
#                 encode_param = [int(cv2.IMWRITE_JPEG_QUALITY), 80]
#                 _, img_encoded = cv2.imencode(".jpg", frame_to_send, encode_param)
#                 files = {"file": ("frame.jpg", img_encoded.tobytes(), "image/jpeg")}

#             try:
#                 start_time = time.time()
#                 response = requests.post(SERVER_URL, files=files, timeout=5)
#                 end_time = time.time()
#                 if response.status_code == 200:
#                     print(f"✅ النتيجة: {response.json()}, وقت الاستجابة: {end_time - start_time:.2f} ثانية")
#                 else:
#                     print(f"⚠️ خطأ في السيرفر: {response.status_code}")
#             except Exception as e:
#                 print("❌ فشل الاتصال:", e)
#         time.sleep(0.05)  # فترة انتظار صغيرة قبل إرسال الفريم التالي

# # بدء خيط الإرسال
# thread = threading.Thread(target=send_frame)
# thread.start()

# try:
#     while True:
#         ret, frame = cap.read()
#         if not ret:
#             print("❌ لم يتم التقاط فريم")
#             break

#         with lock:
#             frame_to_send = frame.copy()  # نسخ الفريم لمشاركته بأمان

#         cv2.imshow("Live Stream", frame)

#         if cv2.waitKey(1) & 0xFF == ord('q'):
#             break

# finally:
#     running = False
#     thread.join()
#     cap.release()
#     cv2.destroyAllWindows()








#كود تجريبي كفرونت اند
import cv2
import requests
import threading
import time

SERVER_URL = "http://172.20.10.2:8000/detect_objects_stream" 
# Camera resolution
CAPTURE_WIDTH = 640
CAPTURE_HEIGHT = 480

cap = cv2.VideoCapture(1)
cap.set(cv2.CAP_PROP_FRAME_WIDTH, CAPTURE_WIDTH)
cap.set(cv2.CAP_PROP_FRAME_HEIGHT, CAPTURE_HEIGHT)
# cap.set(cv2.CAP_PROP_FPS, 20)  # Try with or without depending on your camera

if not cap.isOpened():
    print(" Camera not found")
    exit()

# Shared variable for the frame between threads
frame_to_send = None
lock = threading.Lock()
running = True

# Shared variable for detections between threads
detections = []


def send_frame():
    global frame_to_send, running, detections
    while running:
        if frame_to_send is not None:
            with lock:
                # Compress image before sending (quality 80%)
                encode_param = [int(cv2.IMWRITE_JPEG_QUALITY), 80]
                _, img_encoded = cv2.imencode(".jpg", frame_to_send, encode_param)
                files = {"file": ("frame.jpg", img_encoded.tobytes(), "image/jpeg")}

            try:
                start_time = time.time()
                response = requests.post(SERVER_URL, files=files, timeout=15)
                end_time = time.time()
                if response.status_code == 200:
                    data = response.json()
                    detections = data.get("detections", [])
                    print(f" Result: {detections}, Response time: {end_time - start_time:.2f} seconds")
                else:
                    print(f" Server error: {response.status_code}")
            except Exception as e:
                print(" Connection failed:", e)
        time.sleep(0.05)  # Small delay before sending next frame

# Start sending thread
thread = threading.Thread(target=send_frame)
thread.start()

try:
    while True:
        ret, frame = cap.read()
        if not ret:
            print(" Failed to capture frame")
            break

        with lock:
            frame_to_send = frame.copy()  # Copy frame safely

        cv2.imshow("Live Stream", frame)

        if cv2.waitKey(1) & 0xFF == ord('q'):
            break

finally:
    running = False
    thread.join()
    cap.release()
    cv2.destroyAllWindows()


    


