# # main_api.py
# from fastapi import FastAPI, UploadFile, File, HTTPException
# from fastapi.responses import JSONResponse
# from fastapi.middleware.cors import CORSMiddleware
# import numpy as np
# import cv2
# import asyncio
# import os
# import sys
# import concurrent.futures

# # --- تأكد من أن هذه المسارات والاستيرادات صحيحة حسب بنية مشروعك ---
# sys.path.append(os.path.dirname(os.path.abspath(__file__)))
# from object_detection.object_detector import YOLOv8Detector
# from object_detection.depth_estimator import DepthAnythingEstimator

# app = FastAPI(title="Basirati Project API: Final Version with All Features", version="5.0.0")

# app.add_middleware(
#     CORSMiddleware,
#     allow_origins=["*"],
#     allow_credentials=True,
#     allow_methods=["*"],
#     allow_headers=["*"],
# )

# # --- متغيرات النماذج (بما في ذلك ocr_models) ---
# detector = None
# depth_estimator = None
# ocr_models = None
# executor = concurrent.futures.ThreadPoolExecutor(max_workers=4)

# # الإعدادات الافتراضية
# CONF_THRESHOLD = 0.3
# IOU_THRESHOLD = 0.5
# RESIZE_WIDTH = 640
# RESIZE_HEIGHT = 480

# @app.on_event("startup")
# async def startup():
#     # ---  startup لتحميل كل النماذج الثلاثة ---
#     global detector, depth_estimator, ocr_models
#     try:
#         # 1. تحميل نموذج كشف الأجسام YOLOv8
#         model_path = "C:/Users/HP/Desktop/Basiraty app/object_detection/best_yolov8m.pt"
#         if not os.path.exists(model_path):
#             print(f"❌ Error: YOLOv8 model file not found at {model_path}")
#             return
#         detector = YOLOv8Detector(model_path=model_path, conf_threshold=CONF_THRESHOLD, iou_threshold=IOU_THRESHOLD)
#         print("✅ YOLOv8 model loaded successfully.")

#         # 2. تحميل نموذج تقدير العمق DepthAnything
#         print("Loading DepthAnything model...")
#         depth_estimator = DepthAnythingEstimator()

#         # 3. تحميل نماذج OCR 
#         try:
#             # تأكد من أن هذا المسار صحيح
#             from text_detection.ocr_processor import initialize_ocr_models
#             ocr_models = initialize_ocr_models()
#             print("✅ OCR models loaded successfully")
#         except ImportError:
#             print("⚠️ OCR processor not available")
#             ocr_models = None
#         except Exception as e:
#             print(f"⚠️ Failed to load OCR models: {str(e)}")
#             ocr_models = None

#     except Exception as e:
#         print(f"❌ Failed to initialize models during startup: {str(e)}")

# @app.get("/")
# async def root():
#     return {"message": "Basirati Project API is running", "status": "ok"}

# @app.get("/health")
# async def health_check():
#     # --- تحديث health_check ليشمل كل النماذج ---
#     return {
#         "status": "healthy",
#         "detector_loaded": detector is not None,
#         "depth_estimator_loaded": depth_estimator is not None,
#         "ocr_loaded": ocr_models is not None
#     }

# @app.post("/detect_objects_stream")
# async def detect_objects_stream(file: UploadFile = File(...)):
#     if detector is None or depth_estimator is None:
#         raise HTTPException(status_code=503, detail="A required model is not loaded. Check server logs.")

#     contents = await file.read()
#     nparr = np.frombuffer(contents, np.uint8)
#     img_np = cv2.imdecode(nparr, cv2.IMREAD_COLOR)
#     if img_np is None:
#         raise HTTPException(status_code=400, detail="Invalid image format")

#     img_resized = cv2.resize(img_np, (RESIZE_WIDTH, RESIZE_HEIGHT))

#     loop = asyncio.get_running_loop()

#     yolo_task = loop.run_in_executor(executor, detector.detect_image, img_resized)
#     depth_task = loop.run_in_executor(executor, depth_estimator.estimate_depth, img_resized)
    
#     detections = await yolo_task
#     depth_map = await depth_task

#     if depth_map is not None:
#         min_depth = np.min(depth_map)
#         max_depth = np.max(depth_map)

#         if max_depth > min_depth:
#             normalized_depth_map = 255 * (depth_map - min_depth) / (max_depth - min_depth)
#             normalized_depth_map = normalized_depth_map.astype(np.uint8)
#         else:
#             normalized_depth_map = np.zeros(depth_map.shape, dtype=np.uint8)

#         for det in detections:
#             bbox = det['bbox']
#             center_x = int((bbox[0] + bbox[2]) / 2)
#             center_y = int((bbox[1] + bbox[3]) / 2)
            
#             if 0 <= center_y < normalized_depth_map.shape[0] and 0 <= center_x < normalized_depth_map.shape[1]:
#                 depth_value = normalized_depth_map[center_y, center_x]
#             else:
#                 depth_value = -1

#             if depth_value > 180:
#                 det['distance_text'] = "Very close"
#             elif depth_value > 120:
#                 det['distance_text'] = "Close"
#             elif depth_value > 70:
#                 det['distance_text'] = "Medium"
#             elif depth_value > 30:
#                 det['distance_text'] = "Far"
#             elif depth_value >= 0:
#                 det['distance_text'] = "Very far"
#             else:
#                 det['distance_text'] = "Error in detection"
            
#     else:
#         for det in detections:
#             det['distance_text'] = "Distance estimation failed"

#     return JSONResponse({
#         "success": True,
#         "detections": detections,
#         "count": len(detections)
#     })

# # ======================================================================
# # ############# دالة كشف النصوص #############
# # ======================================================================
# @app.post("/detect_text")
# async def detect_text(file: UploadFile = File(...)):
#     if ocr_models is None:
#         raise HTTPException(status_code=503, detail="OCR models not loaded")
#     try:
#         # تأكد من أن هذا المسار صحيح
#         from text_detection.ocr_processor import process_image_for_ocr

#         contents = await file.read()
#         nparr = np.frombuffer(contents, np.uint8)
#         img_np = cv2.imdecode(nparr, cv2.IMREAD_COLOR)

#         if img_np is None:
#             raise HTTPException(status_code=400, detail="Invalid image format")

#         detected_texts = await asyncio.to_thread(process_image_for_ocr, img_np, ocr_models)

#         return JSONResponse({
#             "success": True,
#             "detected_lines": detected_texts,
#             "count": len(detected_texts)
#         })

#     except Exception as e:
#         print(f"Error in detect_text: {str(e)}")
#         raise HTTPException(status_code=500, detail=f"Text detection failed: {str(e)}")


# if __name__ == "__main__":
#     import uvicorn
#     uvicorn.run("main_api:app", host="0.0.0.0", port=8000, workers=1, reload=True)











#test
# from fastapi import FastAPI, UploadFile, File, HTTPException
# from fastapi.responses import JSONResponse
# from fastapi.middleware.cors import CORSMiddleware
# import numpy as np
# import cv2
# import asyncio
# import os
# import sys
# import concurrent.futures

# # --- تأكد من أن هذه المسارات والاستيرادات صحيحة حسب بنية مشروعك ---
# sys.path.append(os.path.dirname(os.path.abspath(__file__)))
# from object_detection.object_detector import YOLOv8Detector
# from object_detection.depth_estimator import DepthAnythingEstimator
# from text_detection.ocr_processor import initialize_ocr_models, process_image_with_yolo_then_ocr, YOLOTextDetector

# app = FastAPI(title="Basirati Project API: Final Version with YOLO+OCR", version="5.1.0")

# app.add_middleware(
#     CORSMiddleware,
#     allow_origins=["*"],
#     allow_credentials=True,
#     allow_methods=["*"],
#     allow_headers=["*"],
# )

# # --- متغيرات النماذج ---
# detector = None
# depth_estimator = None
# ocr_models = None
# text_detector = None
# executor = concurrent.futures.ThreadPoolExecutor(max_workers=4)

# # الإعدادات الافتراضية
# CONF_THRESHOLD = 0.3
# IOU_THRESHOLD = 0.5
# RESIZE_WIDTH = 640
# RESIZE_HEIGHT = 480

# @app.on_event("startup")
# async def startup():
#     global detector, depth_estimator, ocr_models, text_detector
#     try:
#         # 1. تحميل نموذج كشف الأجسام YOLOv8
#         model_path = "C:/Users/HP/Desktop/Basiraty app/object_detection/best_yolov8m.pt"
#         if not os.path.exists(model_path):
#             print(f"❌ Error: YOLOv8 model file not found at {model_path}")
#         else:
#             detector = YOLOv8Detector(model_path=model_path, conf_threshold=CONF_THRESHOLD, iou_threshold=IOU_THRESHOLD)
#             print("✅ YOLOv8 model loaded successfully.")

#         # 2. تحميل نموذج تقدير العمق DepthAnything
#         print("Loading DepthAnything model...")
#         depth_estimator = DepthAnythingEstimator()

#         # 3. تحميل نماذج OCR
#         try:
#             ocr_models = initialize_ocr_models()
#             print("✅ OCR models loaded successfully")
#         except Exception as e:
#             print(f"⚠️ Failed to load OCR models: {str(e)}")
#             ocr_models = None

#         # 4. تحميل YOLO للنصوص
#         text_model_path = "C:/Users/HP/Desktop/Basiraty app/text_detection/best_ocr_final.pt"
#         if os.path.exists(text_model_path):
#             text_detector = YOLOTextDetector(model_path=text_model_path)
#             print("✅ YOLO text model loaded successfully.")
#         else:
#             print(f"⚠️ YOLO text model not found at {text_model_path}")
#             text_detector = None

#     except Exception as e:
#         print(f"❌ Failed to initialize models during startup: {str(e)}")

# @app.get("/")
# async def root():
#     return {"message": "Basirati Project API is running", "status": "ok"}

# @app.get("/health")
# async def health_check():
#     return {
#         "status": "healthy",
#         "detector_loaded": detector is not None,
#         "depth_estimator_loaded": depth_estimator is not None,
#         "ocr_loaded": ocr_models is not None,
#         "text_detector_loaded": text_detector is not None
#     }

# @app.post("/detect_objects_stream")
# async def detect_objects_stream(file: UploadFile = File(...)):
#     if detector is None or depth_estimator is None:
#         raise HTTPException(status_code=503, detail="A required model is not loaded. Check server logs.")

#     contents = await file.read()
#     nparr = np.frombuffer(contents, np.uint8)
#     img_np = cv2.imdecode(nparr, cv2.IMREAD_COLOR)
#     if img_np is None:
#         raise HTTPException(status_code=400, detail="Invalid image format")

#     img_resized = cv2.resize(img_np, (RESIZE_WIDTH, RESIZE_HEIGHT))
#     loop = asyncio.get_running_loop()

#     yolo_task = loop.run_in_executor(executor, detector.detect_image, img_resized)
#     depth_task = loop.run_in_executor(executor, depth_estimator.estimate_depth, img_resized)
    
#     detections = await yolo_task
#     depth_map = await depth_task

#     if depth_map is not None:
#         min_depth = np.min(depth_map)
#         max_depth = np.max(depth_map)
#         normalized_depth_map = np.zeros_like(depth_map, dtype=np.uint8)
#         if max_depth > min_depth:
#             normalized_depth_map = 255 * (depth_map - min_depth) / (max_depth - min_depth)
#             normalized_depth_map = normalized_depth_map.astype(np.uint8)

#         for det in detections:
#             bbox = det['bbox']
#             center_x = int((bbox[0] + bbox[2]) / 2)
#             center_y = int((bbox[1] + bbox[3]) / 2)
#             depth_value = normalized_depth_map[center_y, center_x] if (0 <= center_y < normalized_depth_map.shape[0] and 0 <= center_x < normalized_depth_map.shape[1]) else -1

#             if depth_value > 180:
#                 det['distance_text'] = "Very close"
#             elif depth_value > 120:
#                 det['distance_text'] = "Close"
#             elif depth_value > 70:
#                 det['distance_text'] = "Medium"
#             elif depth_value > 30:
#                 det['distance_text'] = "Far"
#             elif depth_value >= 0:
#                 det['distance_text'] = "Very far"
#             else:
#                 det['distance_text'] = "Error in detection"
#     else:
#         for det in detections:
#             det['distance_text'] = "Distance estimation failed"

#     return JSONResponse({
#         "success": True,
#         "detections": detections,
#         "count": len(detections)
#     })

# # ================= دالة كشف النصوص =================
# @app.post("/detect_text")
# async def detect_text(file: UploadFile = File(...)):
#     if ocr_models is None:
#         raise HTTPException(status_code=503, detail="OCR models not loaded")
#     try:
#         contents = await file.read()
#         nparr = np.frombuffer(contents, np.uint8)
#         img_np = cv2.imdecode(nparr, cv2.IMREAD_COLOR)
#         if img_np is None:
#             raise HTTPException(status_code=400, detail="Invalid image format")

#         detected_texts = await asyncio.to_thread(process_image_with_yolo_then_ocr, img_np, text_detector, ocr_models)

#         return JSONResponse({
#             "success": True,
#             "detected_lines": detected_texts,
#             "count": len(detected_texts)
#         })

#     except Exception as e:
#         print(f"Error in detect_text: {str(e)}")
#         raise HTTPException(status_code=500, detail=f"Text detection failed: {str(e)}")


# if __name__ == "__main__":
#     import uvicorn
#     uvicorn.run("main_api:app", host="0.0.0.0", port=8000, workers=1, reload=True)




# main_api.py
from fastapi import FastAPI, UploadFile, File, HTTPException
from fastapi.responses import JSONResponse
from fastapi.middleware.cors import CORSMiddleware
import numpy as np
import cv2
import asyncio
import os
import sys
import concurrent.futures

sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
#sys.path.append(os.path.dirname(os.path.abspath(__file__)))


from object_detection.object_detector import YOLOv8Detector
from object_detection.depth_estimator import DepthAnythingEstimator
# استيراد الدوال والمسار من ملف معالج النصوص
from text_detection.ocr_processor import initialize_ocr_models, process_image_for_ocr, YOLO_MODEL_PATH as TEXT_MODEL_PATH

app = FastAPI(title="Basirati Project API", version="5.0.0")


detector = None
depth_estimator = None
ocr_models = None 
executor = concurrent.futures.ThreadPoolExecutor(max_workers=4)

CONF_THRESHOLD = 0.3
IOU_THRESHOLD = 0.5
RESIZE_WIDTH = 640
RESIZE_HEIGHT = 480


@app.on_event("startup")
async def startup():
    # ---  startup لتحميل كل النماذج الثلاثة ---
    global detector, depth_estimator, ocr_models
    print("Server starting up... Loading all models.")
    try:
        # تحميلYOLOv8
        object_model_path = "/object_detection/best_yolov8m.pt"
        if not os.path.exists(object_model_path):
            print(f"Error: YOLOv8 object model file not found at {object_model_path}")
        else:
            detector = YOLOv8Detector(model_path=object_model_path, conf_threshold=CONF_THRESHOLD, iou_threshold=IOU_THRESHOLD)
            print("YOLOv8 object detection model loaded successfully.")

        # تحميل  DepthAnything
        print("Loading DepthAnything model...")
        depth_estimator = DepthAnythingEstimator()
        print("DepthAnything model loaded successfully.")

        # تحميل  OCR (YOLOv8 للنصوص + EasyOCR)
        print("Loading OCR models (YOLOv8 for text + EasyOCR)...")
        if not os.path.exists(TEXT_MODEL_PATH):
             print(f"Error: YOLOv8 text model file not found at {TEXT_MODEL_PATH}")
             ocr_models = None
        else:
           
            ocr_models = initialize_ocr_models(yolo_model_path=TEXT_MODEL_PATH)
            if ocr_models:
                print("OCR models loaded successfully.")
            else:
                print("Failed to load OCR models. Check logs in ocr_processor.")

    except Exception as e:
        print(f"Critical error during model initialization: {str(e)}")

@app.get("/")
async def root():
    return {"message": "Basirati Project API is running", "status": "ok"}

@app.get("/health")
async def health_check():
    # --- health_check ---
    return {
        "status": "healthy",
        "object_detector_loaded": detector is not None,
        "depth_estimator_loaded": depth_estimator is not None,
        "ocr_processor_loaded": ocr_models is not None
    }

@app.post("/detect_objects_stream")
async def detect_objects_stream(file: UploadFile = File(...)):
    if detector is None or depth_estimator is None:
        raise HTTPException(status_code=503, detail="A required model is not loaded. Check server logs.")

    contents = await file.read()
    nparr = np.frombuffer(contents, np.uint8)
    img_np = cv2.imdecode(nparr, cv2.IMREAD_COLOR)
    if img_np is None:
        raise HTTPException(status_code=400, detail="Invalid image format")

    # تأكد من أن الأبعاد هي أعداد صحيحة قبل تمريرها
    dsize = (int(RESIZE_WIDTH), int(RESIZE_HEIGHT))
    img_resized = cv2.resize(img_np, dsize)


    loop = asyncio.get_running_loop()

    yolo_task = loop.run_in_executor(executor, detector.detect_image, img_resized)
    depth_task = loop.run_in_executor(executor, depth_estimator.estimate_depth, img_resized)
    
    detections = await yolo_task
    depth_map = await depth_task

    if depth_map is not None:
        min_depth = np.min(depth_map)
        max_depth = np.max(depth_map)

        if max_depth > min_depth:
            normalized_depth_map = 255 * (depth_map - min_depth) / (max_depth - min_depth)
            normalized_depth_map = normalized_depth_map.astype(np.uint8)
        else:
            normalized_depth_map = np.zeros(depth_map.shape, dtype=np.uint8)

        for det in detections:
            bbox = det['bbox']
            center_x = int((bbox[0] + bbox[2]) / 2)
            center_y = int((bbox[1] + bbox[3]) / 2)
            
            if 0 <= center_y < normalized_depth_map.shape[0] and 0 <= center_x < normalized_depth_map.shape[1]:
                depth_value = normalized_depth_map[center_y, center_x]
            else:
                depth_value = -1

            if depth_value > 180:
                det['distance_text'] = "Very close"
            elif depth_value > 120:
                det['distance_text'] = "Close"
            elif depth_value > 70:
                det['distance_text'] = "Medium"
            elif depth_value > 30:
                det['distance_text'] = "Far"
            elif depth_value >= 0:
                det['distance_text'] = "Very far"
            else:
                det['distance_text'] = "Error in detection"
    else:
        for det in detections:
            det['distance_text'] = "Distance estimation failed"

    return JSONResponse({
        "success": True,
        "detections": detections,
        "count": len(detections)
    })



@app.post("/detect_text")
async def detect_text(file: UploadFile = File(...)):
    if ocr_models is None:
        raise HTTPException(status_code=503, detail="OCR models are not loaded. Check server logs.")
    try:
        contents = await file.read()
        nparr = np.frombuffer(contents, np.uint8)
        img_np = cv2.imdecode(nparr, cv2.IMREAD_COLOR)

        if img_np is None:
            raise HTTPException(status_code=400, detail="Invalid image format")

        detected_texts = await asyncio.to_thread(process_image_for_ocr, img_np, ocr_models)

        return JSONResponse({
            "success": True,
            "detected_lines": detected_texts,
            "count": len(detected_texts)
        })

    except Exception as e:
        print(f"Error in detect_text endpoint: {str(e)}")
        raise HTTPException(status_code=500, detail=f"An internal error occurred during text detection: {str(e)}")



if __name__ == "__main__":
    import uvicorn
    uvicorn.run(
        "main_api:app",
        host="0.0.0.0",
        port=8000  
    )



# if __name__ == "__main__":
#     import uvicorn
#     uvicorn.run(
#         "main_api:app",
#         host="0.0.0.0",
#         port=443,  # المنفذ الآمن
#         ssl_keyfile="key.pem",
#         ssl_certfile="cert.pem"
#     )


#uvicorn api.main:app --reload 
#uvicorn api.main:app --host 0.0.0.0 --port 8000
#lt --port 8000 --subdomain baserti-api
#uvicorn api.main:app --reload --ssl-keyfile key.pem --ssl-certfile cert.pem --port 443 --host 0.0.0.0

